IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_BancoMacro_Proveedores_OP_OPG_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_BancoMacro_Proveedores_OP_OPG_TX
END
GO

CREATE FUNCTION dbo.CF_BancoMacro_Proveedores_OP_OPG_TX(@pId_Trans INT, @pId_Valor INT, @pNroSecuencia INT) 
RETURNS CHAR(271)
AS
BEGIN

/*================================================================================================================================*/

/*Variables del Archivo*/
DECLARE @Retorno						CHAR(271)

/*--------------------------------------------------------------------------------------------------------------------------------*/

DECLARE @aTTD_BNF_ID			CHAR(2)		-- NRO: 01. NOMBRE: TTD_BNF_ID.				TIPO: N. TAM: 002. POS. INI: 001. POS_FIN: 002. OBSERVACION: Tipo de documento del beneficiario
DECLARE @aBNF_NUMDOC			CHAR(11)	-- NRO: 02. NOMBRE: BNF_NUMDOC.				TIPO: N. TAM: 011. POS. INI: 003. POS_FIN: 013. OBSERVACION: Numero de Documento del Beneficiario (sin guiones ni puntos)
DECLARE @aSUC_ENTREGA			CHAR(3)		-- NRO: 03. NOMBRE: SUC_ENTREGA.			TIPO: N. TAM: 003. POS. INI: 014. POS_FIN: 016. OBSERVACION: Sucursal de Entrega del cheque. (Únicamente para las modalidades 1 y 9. Para el resto va la Sucursal de radicacion de la cuenta de pago)
DECLARE @aOPG_IDOPGCLI			CHAR(30)	-- NRO: 04. NOMBRE: OPG_IDOPGCLI.			TIPO: A. TAM: 030. POS. INI: 017. POS_FIN: 046. OBSERVACION: Clave Identificatoria de la Orden de Pago segun el cliente. (Id. de pago no puede repetirse nunca. Debe ser un dato univoco)
DECLARE @aOPG_ORDENALT			CHAR(120)	-- NRO: 05. NOMBRE: OPG_ORDENALT.			TIPO: A. TAM: 120. POS. INI: 047. POS_FIN: 166. OBSERVACION: Orden del pago o Razon social o denominacion del beneficiario.
DECLARE @aOPG_IMP_PAGO			CHAR(15)	-- NRO: 06. NOMBRE: OPG_IMP_PAGO.			TIPO: D. TAM: 015. POS. INI: 167. POS_FIN: 181. OBSERVACION: Importe del Pago.
DECLARE @aCTA_CUENTADEBITO		CHAR(15)	-- NRO: 07. NOMBRE: CTA_CUENTADEBITO.		TIPO: N. TAM: 015. POS. INI: 182. POS_FIN: 196. OBSERVACION: Cuenta de debito (de la empresa que paga)
DECLARE @aOPG_CUENTAPAGO		CHAR(22)	-- NRO: 08. NOMBRE: OPG_CUENTAPAGO.			TIPO: N. TAM: 022. POS. INI: 197. POS_FIN: 218. OBSERVACION: Para modalidad de pago 2 o 4 va la cuenta del beneficiario (CBU). Para modalidad de pago 1, 6, 8 y 9 va el Numero de Cheque de la chequera entregada.
DECLARE @aMPG_ID				CHAR(2)		-- NRO: 09. NOMBRE: MPG_ID.					TIPO: N. TAM: 002. POS. INI: 219. POS_FIN: 220. OBSERVACION: Modalidad de Pago
DECLARE @aOPG_MAR_REGCHQ		CHAR(1)		-- NRO: 10. NOMBRE: OPG_MAR_REGCHQ.			TIPO: N. TAM: 001. POS. INI: 221. POS_FIN: 221. OBSERVACION: Marca de Registracion de Cheque. (1=Con la leyenda No a la Orden, 2=Sin la leyenda No a la Orden). (Para otras modalidades de pago (no cheques), completar con 0)
DECLARE @aOPG_FEC_PAGO			CHAR(10)	-- NRO: 11. NOMBRE: OPG_FEC_PAGO.			TIPO: D. TAM: 010. POS. INI: 222. POS_FIN: 231. OBSERVACION: Fecha de Emision del pago en el cheque.
DECLARE @aOPG_FEC_PAGODIFERIDO	CHAR(10)	-- NRO: 12. NOMBRE: OPG_FEC_PAGODIFERIDO.	TIPO: D. TAM: 010. POS. INI: 232. POS_FIN: 241. OBSERVACION: Fecha de Pago Diferido (Requerido solo para modalidad de pago "cheque de pago diferido")
DECLARE @aUSR_FIRMANTE1			CHAR(10)	-- NRO: 13. NOMBRE: USR_FIRMANTE1.			TIPO: A. TAM: 010. POS. INI: 242. POS_FIN: 251. OBSERVACION: Dejar en blanco
DECLARE @aUSR_FIRMANTE2			CHAR(10)	-- NRO: 14. NOMBRE: USR_FIRMANTE2.			TIPO: A. TAM: 010. POS. INI: 252. POS_FIN: 261. OBSERVACION: Dejar en blanco
DECLARE @aUSR_FIRMANTE3			CHAR(10)	-- NRO: 15. NOMBRE: USR_FIRMANTE3.			TIPO: A. TAM: 010. POS. INI: 262. POS_FIN: 271. OBSERVACION: Dejar en blanco
/*FIN Variables del Archivo*/

/*================================================================================================================================*/

/*Variables de Calculo intermedio*/
DECLARE @Importe					DECIMAL(12,2)
DECLARE @Fecha_Cbte					DATETIME
DECLARE @Id_Tipo_Val				CHAR(3)
DECLARE @Fecha_Emision				DATETIME
DECLARE @Fecha_Acreditacion			DATETIME
DECLARE @Transferible				TINYINT
DECLARE @Id_Proveedor				INT
DECLARE @Cuit						VARCHAR(19)
DECLARE @Valor_Nro					INT
/*FIN Variables de Calculo intermedio*/


/*Asignacion de variables*/
SELECT
@Importe			= ISNULL(Importe, 0),
@Id_Tipo_Val		= ISNULL(Id_Tipo_Val, '   '),
@Fecha_Emision		= CONVERT(DATE, ISNULL(Fecha_Emision, '19000101')),
@Fecha_Acreditacion	= CONVERT(DATE, ISNULL(Fecha_Acreditacion, '19000101')),
@Transferible		= ISNULL(Transferible, 0),
@Valor_Nro			= ISNULL(Valor_Nro, 0)
FROM Valores
WHERE
Id_Trans = @pId_Trans
AND Id_Valor = @pId_Valor

SELECT
@Fecha_Cbte		= ISNULL(Fecha, '19000101'),
@Id_Proveedor	= ISNULL(Id_Proveedor, 0)
FROM Cbtes
WHERE
Id_Trans = @pId_Trans

SELECT
@Cuit			= LTRIM(RTRIM(ISNULL(Cuit, '')))
FROM Proveedores
WHERE
Id_Proveedor = @Id_Proveedor
/*FIN Asignacion de variables*/

/*================================================================================================================================*/

/*
Tipos de Documento:

3 = D.N.I.
10 = C.U.I.T  Clave Unica de identificacion tributaria
11 = Cod. de identidad de paises limetrofes
13 = C.U.I.L. - Clave Unica de Ident. Laboral
14 = C.D.I. - Clave de Identificacion
*/
SET @aTTD_BNF_ID			= '10'

SET @aBNF_NUMDOC			= SUBSTRING(@Cuit, 1, 11)

SET @aOPG_IDOPGCLI			= (SELECT RIGHT('000000000000000000000000000000' + CAST(@pId_Trans AS VARCHAR), 30))

SET @aOPG_ORDENALT			= dbo.CF_Cbte_Descrip(@pId_Trans)

SET @aOPG_IMP_PAGO			= (SELECT RIGHT('000000000000000' + CAST(CAST((ISNULL(@Importe, 0)) * 100 AS INT) AS VARCHAR), 15))

SET @aCTA_CUENTADEBITO		= (SELECT RIGHT('000000000000000' + dbo.CF_xParam('BcoMacro_NroCtaDeb'), 15))



/*
Modalidades de Pago:

1 = Cheque Comn
2 = Acreditacion en Cuenta
4 = Acreditacion en Cuenta Otros Bancos
5 = Efectivo
9 = Cheque de Pago Diferido
6 = ECHEQ Comn
8 = ECHEQ de Pago Diferido
*/
IF(@Id_Tipo_Val IN ('CH3', 'CHP'))
BEGIN
	SET @aMPG_ID				= '1'
END
ELSE
BEGIN
	SET @aMPG_ID				= '2'
END	

IF(@aMPG_ID IN ('1','9'))
BEGIN
	SET @aSUC_ENTREGA			= (SELECT RIGHT('000' + dbo.CF_xParam('BcoMacro_SucEntrega'), 3))
END
ELSE
BEGIN
	SET @aSUC_ENTREGA			= (SELECT RIGHT('000' + dbo.CF_xParam('BcoMacro_SucEntrega'), 3))
END

IF(@aMPG_ID IN ('2','4'))
BEGIN
	SET @aOPG_CUENTAPAGO		= (SELECT RIGHT('0000000000000000000000' + CAST(@Valor_Nro AS VARCHAR), 22))
END
ELSE
BEGIN
	SET @aOPG_CUENTAPAGO		= (SELECT RIGHT('0000000000000000000000' + CAST(@Valor_Nro AS VARCHAR), 22))
END

/*
Marca de Registracion de los Cheques

1 = Cheque cruzado con leyenda "No a la Orden"
2 = Cheque cruzado sin leyenda "No a la Orden"
*/
IF(@Fecha_Emision = @Fecha_Acreditacion)
BEGIN
	/*Cheque al dia*/
	IF(@Transferible = 1)
	BEGIN
		/*No a la orden*/
		SET @aOPG_MAR_REGCHQ	= 1
	END
	ELSE
	BEGIN
		/*Sin leyenda no a la orden*/
		SET @aOPG_MAR_REGCHQ	= 2
	END
END
ELSE
BEGIN
	/*Cheque Pago Diferido (CPD)*/
	IF(@Transferible = 1)
	BEGIN
		/*No a la orden*/
		SET @aOPG_MAR_REGCHQ	= 1
	END
	ELSE
	BEGIN
		/*Sin leyenda no a la orden*/
		SET @aOPG_MAR_REGCHQ	= 2
	END
END	



SET @aOPG_FEC_PAGO			= (/*DD*/RIGHT('00' + CAST(DATEPART(dd, @Fecha_Cbte) AS VARCHAR),2) + '/' + /*MM*/RIGHT('00' + CAST(DATEPART(mm, @Fecha_Cbte) AS VARCHAR),2) + '/' + /*AAAA*/CAST(DATEPART(YY, @Fecha_Cbte) AS CHAR(4)))

SET @aOPG_FEC_PAGODIFERIDO	= (/*DD*/RIGHT('00' + CAST(DATEPART(dd, @Fecha_Cbte) AS VARCHAR),2) + '/' + /*MM*/RIGHT('00' + CAST(DATEPART(mm, @Fecha_Cbte) AS VARCHAR),2) + '/' + /*AAAA*/CAST(DATEPART(YY, @Fecha_Cbte) AS CHAR(4)))

SET @aUSR_FIRMANTE1			= '          '

SET @aUSR_FIRMANTE2			= '          '

SET @aUSR_FIRMANTE3			= '          '

/*================================================================================================================================*/

SET @Retorno =	@aTTD_BNF_ID				+ 
				@aBNF_NUMDOC				+ 
				@aSUC_ENTREGA				+ 
				@aOPG_IDOPGCLI				+ 
				@aOPG_ORDENALT				+ 
				@aOPG_IMP_PAGO				+ 
				@aCTA_CUENTADEBITO			+ 
				@aOPG_CUENTAPAGO			+ 
				@aMPG_ID					+ 
				@aOPG_MAR_REGCHQ			+ 
				@aOPG_FEC_PAGO				+ 
				@aOPG_FEC_PAGODIFERIDO		+ 
				@aUSR_FIRMANTE1				+ 
				@aUSR_FIRMANTE2				+ 
				@aUSR_FIRMANTE3	

/*================================================================================================================================*/
					
RETURN @Retorno
END